/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.ventas;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesor;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Comprador;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.validator.rule.VentasValidationRule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Venta
extends ObjetoModeloSucesor<Iva> {
    private static final long serialVersionUID = 4804376755120919918L;
    public static final String CC_COMPROBANTES_VENTA = "comprobantesVenta";
    public static final String C_TOTAL = "totalVentaPorClienteInterfaz";
    public static final String C_TOTAL_REEMBOLSO = "totalReembolsoPorClienteInterfaz";
    private Comprador comprador = new Comprador("tpIdCliente", "idCliente");
    private final List<ComprobanteVenta> comprobantesVenta;
    private BigDecimal totalVentaPorCliente;
    private BigDecimal totalCompensacionesPorCliente;
    private BigDecimal totalReembolsoPorCliente;
    private String totalVentaPorClienteInterfaz;

    public Venta() {
        this.comprador.setPropietario((ObjetoModelo)this);
        this.comprobantesVenta = new ArrayList<ComprobanteVenta>();
        this.totalVentaPorCliente = new BigDecimal("0.00");
        this.totalVentaPorClienteInterfaz = "0.00";
        this.totalReembolsoPorCliente = new BigDecimal("0.00");
        this.totalCompensacionesPorCliente = new BigDecimal("0.00");
    }

    public void calcularTotalVentaPorCliente() {
        this.setTotalVentaPorCliente(BigDecimal.ZERO);
        this.setTotalReembolsoPorCliente(new BigDecimal("0.00"));
        for (ComprobanteVenta comprobanteVenta : this.comprobantesVenta) {
            if (VentasValidationRule.esComprobanteElectronico(comprobanteVenta)) continue;
            if (((Iva)this.getPropietario()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
                if (Constantes.COMPROBANTES_VENTA_RESTAN_DESDE_MARZO_2015.contains(comprobanteVenta.getTipoComprobante())) {
                    this.setTotalVentaPorCliente(this.totalVentaPorCliente.subtract(comprobanteVenta.getTotalComprobante()));
                    continue;
                }
                if (Constantes.COMPROBANTES_VENTA_SUMAN_DESDE_MARZO_2015.contains(comprobanteVenta.getTipoComprobante())) {
                    this.setTotalVentaPorCliente(this.totalVentaPorCliente.add(comprobanteVenta.getTotalComprobante()));
                    continue;
                }
                if (Constantes.COMPROBANTES_VENTA_REEMBOLSO_DESDE_MARZO_2015.contains(comprobanteVenta.getTipoComprobante())) {
                    this.setTotalReembolsoPorCliente(this.totalReembolsoPorCliente.add(comprobanteVenta.getTotalComprobante()));
                    continue;
                }
                if (!Constantes.COMPROBANTES_VENTA_RESTAN_REEMBOLSO_DESDE_MARZO_2015.contains(comprobanteVenta.getTipoComprobante())) continue;
                this.setTotalReembolsoPorCliente(this.totalReembolsoPorCliente.subtract(comprobanteVenta.getTotalComprobante()));
                continue;
            }
            if (Constantes.COMPROBANTES_VENTA_RESTAN.contains(comprobanteVenta.getTipoComprobante())) {
                this.setTotalVentaPorCliente(this.totalVentaPorCliente.subtract(comprobanteVenta.getTotalComprobante()));
                continue;
            }
            if (Constantes.COMPROBANTES_VENTA_SUMAN.contains(comprobanteVenta.getTipoComprobante())) {
                this.setTotalVentaPorCliente(this.totalVentaPorCliente.add(comprobanteVenta.getTotalComprobante()));
                continue;
            }
            if (!Constantes.COMPROBANTES_VENTA_REEMBOLSO.contains(comprobanteVenta.getTipoComprobante())) continue;
            this.setTotalReembolsoPorCliente(this.totalReembolsoPorCliente.add(comprobanteVenta.getTotalComprobante()));
        }
        this.setTotalVentaPorClienteInterfaz(this.getTotalVentaPorCliente());
    }

    public void calcularTotalCompensacionesPorCliente() {
        this.limpiarTotalCompensaciones();
        for (ComprobanteVenta comprobanteVenta : this.comprobantesVenta) {
            if (!((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016() || VentasValidationRule.esComprobanteElectronico(comprobanteVenta)) continue;
            for (Compensacion compensacion : comprobanteVenta.getCompensaciones()) {
                if (!VentasValidationRule.esCompensacionPorLeyDeSolidaridad(compensacion.getCodigo())) continue;
                BigDecimal montoCompensacionSolidaridad = new BigDecimal(compensacion.getMonto());
                this.setTotalCompensacionesPorCliente(this.totalCompensacionesPorCliente.add(montoCompensacionSolidaridad));
            }
        }
    }

    private void limpiarTotalCompensaciones() {
        this.setTotalCompensacionesPorCliente(BigDecimal.ZERO);
    }

    public void agregarComprobantesVenta(ComprobanteVenta comprobanteCliente) {
        comprobanteCliente.setPropietario((ObjetoModelo)this);
        this.comprobantesVenta.add(comprobanteCliente);
        this.firePropertyChange(CC_COMPROBANTES_VENTA, null, this.comprobantesVenta);
    }

    public boolean eliminarComprobantesVenta(ComprobanteVenta comprobanteCliente) {
        boolean eliminado = this.comprobantesVenta.remove((Object)comprobanteCliente);
        if (eliminado) {
            this.firePropertyChange(CC_COMPROBANTES_VENTA, null, this.comprobantesVenta);
        }
        return eliminado;
    }

    public Comprador getComprador() {
        return this.comprador;
    }

    public List<ComprobanteVenta> getComprobantesVenta() {
        return this.comprobantesVenta;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public String getTotalVentaPorCliente() {
        this.totalVentaPorCliente = this.totalVentaPorCliente.setScale(2, 2);
        return this.totalVentaPorCliente.toString();
    }

    public void setTotalVentaPorCliente(BigDecimal totalVentaPorCliente) {
        this.totalVentaPorCliente = totalVentaPorCliente;
    }

    public String getTotalReembolsoPorCliente() {
        return this.totalReembolsoPorCliente.toString();
    }

    public void setTotalReembolsoPorCliente(BigDecimal totalReembolsoPorCliente) {
        this.totalReembolsoPorCliente = totalReembolsoPorCliente;
    }

    public String getTotalVentaPorClienteInterfaz() {
        return this.totalVentaPorClienteInterfaz;
    }

    public void setTotalVentaPorClienteInterfaz(String totalVentaPorClienteInterfaz) {
        String oldValue = this.totalVentaPorClienteInterfaz;
        this.totalVentaPorClienteInterfaz = totalVentaPorClienteInterfaz;
        this.firePropertyChange(C_TOTAL, oldValue, this.totalVentaPorClienteInterfaz);
    }

    public BigDecimal getTotalCompensacionesPorCliente() {
        return this.totalCompensacionesPorCliente;
    }

    public void setTotalCompensacionesPorCliente(BigDecimal totalCompensacionesPorCliente) {
        this.totalCompensacionesPorCliente = totalCompensacionesPorCliente;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Venta)) {
            return false;
        }
        Venta other = (Venta)((Object)obj);
        return !(this.comprador == null ? other.comprador != null : !this.comprador.equals((Object)other.comprador));
    }
}

